@extends('user')
@section('style')
@stop
@section('content')
    @include('partials.breadcrumb')


    <div class="dedicated-plan">
        <div class="container">

            <div class="row">
                <div class="col-12">
                    @include('errors.error')
                    <div class="plan-table">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('SL')</th>
                                <th scope="col">@lang('Send Amount')</th>
                                <th scope="col">@lang('Receive Amount')</th>
                                <th scope="col">@lang('Status')</th>
                                <th scope="col">@lang('Action')</th>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach($exchanges as $k=>$exchange)
                                <tr>
                                    <th data-label="@lang('SL')">{{++$k}}</th>
                                    <td data-label="@lang('Send Amount')"> <strong>{{ number_format($exchange->send_amount, $basic->decimal) }}</strong> {{ $exchange->send_method->name }}</td>
                                    <td data-label="@lang('Receive Amount')"><strong>{{ number_format($exchange->receive_amount, $basic->decimal) }}</strong> {{ $exchange->receive_method->name }} </td>
                                    <td data-label="@lang('Status')">
                                        @if($exchange->status == 1)
                                        <span class="badge badge-warning">@lang('Pending')</span>
                                        @elseif($exchange->status == 2)
                                        <span class="badge badge-success">@lang('Completed')</span>
                                        @elseif($exchange->status == -2)
                                        <span class="badge badge-danger">@lang('Refunded')</span>
                                        @elseif($exchange->status == -1)
                                            <span class="badge badge-danger">@lang('Cancelled')</span>
                                            @endif

                                    </td>



                                    <td data-label="Action">
                                        <a href="{{route('exchange.details',$exchange->trx)}}" class="btn btn-info btn-sm" target="_blank">@lang('Details')</a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    {!! $exchanges->links() !!}



                </div>
            </div>

        </div>
    </div>

@stop


@section('script')
@stop
@section('js')

@stop